<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 13.12.13 11:30
 */

namespace VM\AdminBundle\Services;


use Doctrine\ORM\EntityManager;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserToken;
use VM\ApiBundle\Entity\UserTokenList;

class TokensGenerator
{
    /**
     * @var EntityManager
     */
    protected $EntityManager;


    public function __construct(EntityManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;
    }


    public function getNewTokensList(User $User, User $GenerateBy = null)
    {
        $lastTokenList = $this->getUserLastTokenList($User);

        $UserTokenList = new UserTokenList();
        $UserTokenList->setUser($User);
        $UserTokenList->setGenerateBy($GenerateBy);
        $UserTokenList->setIsActive(true);
        if($lastTokenList !== false)
        {
            $lastTokenList->setIsActive(false);
            $UserTokenList->setSequence($lastTokenList->getSequence() + 1);
        }
        else
        {
            $UserTokenList->setSequence(1);
        }

        $this->EntityManager->persist($UserTokenList);

        $seq = 1;
        foreach($this->generateListOfTokens() as $token)
        {
            $UserToken = new UserToken();
            $UserToken->setTokenList($UserTokenList);
            $UserToken->setUsed(false);
            $UserToken->setSequence($seq);
            $UserToken->setToken($token);

            $UserTokenList->addToken($UserToken);
            $this->EntityManager->persist($UserToken);

            $seq++;
        }

        return $UserTokenList;
    }


    /**
     * @param User $User
     * @return UserTokenList
     */
    protected function getUserLastTokenList(User $User)
    {
        $tokens = $User->getTokensList();
        return (!empty($tokens) && $tokens->count() > 0) ? $tokens[0] : false;
    }


    protected function generateListOfTokens()
    {
        $start = rand(100000, 900000);
        $token = $start;
        $listOfTokens = array();
        while(count($listOfTokens) < 40)
        {
            if(array_search($token, $listOfTokens) === false)
            {
                $listOfTokens[] = $token;
            }
            $token += rand(1, 18000);
            $token %= 1000000;
            if($token < 100000)
            {
                $token += $start;
            }
        }
        shuffle($listOfTokens);
        return $listOfTokens;
    }
} 